require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Nimble"

-- ==============================
-- Nimble: per-level multipliers
-- ==============================
-- Combat walk speed multiplier (vs. baseline level 0 = 1.00)
-- Level 1..10 → 1.10, 1.14, 1.18, 1.22, 1.26, 1.30, 1.34, 1.38, 1.42, 1.50
local _COMBAT_WALK_MULT_BY_LVL = { 1.10, 1.14, 1.18, 1.22, 1.26, 1.30, 1.34, 1.38, 1.42, 1.50 }

-- Footstep noise multiplier (stacks with Lightfooted)
-- Level 1..10 → 0.90, 0.86, 0.82, 0.78, 0.74, 0.70, 0.66, 0.62, 0.58, 0.50
local _FOOTSTEP_NOISE_MULT_BY_LVL = { 0.90, 0.86, 0.82, 0.78, 0.74, 0.70, 0.66, 0.62, 0.58, 0.50 }

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    local walkMult  = _COMBAT_WALK_MULT_BY_LVL[lvl] or 1.0
    local noiseMult = _FOOTSTEP_NOISE_MULT_BY_LVL[lvl] or 1.0

    -- Convert to +/- percentages relative to baseline (1.00)
    local walkPlusPct   = math.floor(((walkMult - 1.0) * 100) + 0.5)   -- e.g., 1.10 → +10
    local noiseMinusPct = math.floor(((1.0 - noiseMult) * 100) + 0.5) -- e.g., 0.90 → -10

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
    ctx.add(ST.getText("IGUI_DST_Nimble_val_CombatWalk", tostring(walkPlusPct or "-")))
    ctx.add(ST.getText("IGUI_DST_Nimble_val_FootstepNoise", tostring(noiseMinusPct or "-")))
    ctx.addSeparator()
    ctx.add(ST.getText("IGUI_DST_Nimble_info_Stacks"))
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)